<?php
// Fungsi untuk mendapatkan path koneksi yang benar
function getKoneksiPath() {
    $paths = [
        __DIR__ . '/koneksi.php',
        __DIR__ . '/../koneksi.php',
        './koneksi.php',
        '../koneksi.php'
    ];
    
    foreach ($paths as $path) {
        if (file_exists($path)) {
            return $path;
        }
    }
    return null;
}

// Coba include koneksi.php
$koneksiPath = getKoneksiPath();
if ($koneksiPath && file_exists($koneksiPath)) {
    include $koneksiPath;
} else {
    // Fallback koneksi langsung
    $host = 'localhost';
    $user = 'root';
    $pass = '';
    $db   = 'db_bukutamu';
    
    $koneksi = mysqli_connect($host, $user, $pass, $db);
}

// Cek koneksi
if (!$koneksi) {
    ?>
    <!DOCTYPE html>
    <html lang="id">
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
        <title>Koneksi Gagal - Admin</title>
        <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
        <style>
            body {
                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                min-height: 100vh;
                display: flex;
                align-items: center;
                justify-content: center;
                padding: 20px;
            }
            .error-box {
                background: white;
                border-radius: 20px;
                padding: 40px;
                max-width: 600px;
                width: 100%;
                box-shadow: 0 20px 60px rgba(0,0,0,0.3);
                text-align: center;
            }
            .error-icon {
                font-size: 80px;
                color: #ef4444;
                margin-bottom: 20px;
            }
            .btn-home {
                background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
                color: white;
                padding: 12px 30px;
                border-radius: 10px;
                text-decoration: none;
                display: inline-block;
                margin-top: 20px;
            }
        </style>
    </head>
    <body>
        <div class="error-box">
            <div class="error-icon"><i class="fas fa-database"></i></div>
            <h2>Koneksi Database Gagal</h2>
            <p>Pastikan XAMPP berjalan dan database db_bukutamu sudah dibuat.</p>
            <a href="index.php" class="btn-home">Kembali ke Beranda</a>
        </div>
    </body>
    </html>
    <?php
    exit();
}

// Query untuk mengambil data tamu
$query = "SELECT * FROM tamu ORDER BY tanggal_kunjungan DESC";
$result = mysqli_query($koneksi, $query);

// Hitung total tamu
$total_tamu = mysqli_num_rows($result);
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Data Tamu - Admin Panel</title>
    
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- DataTables CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    
    <!-- FontAwesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    
    <style>
        :root {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --success: #10b981;
            --dark: #1f2937;
            --gray: #6b7280;
            --light: #f9fafb;
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background: #f3f4f6;
            margin: 0;
            padding: 0;
        }
        
        .navbar-custom {
            background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
            box-shadow: 0 2px 10px rgba(99, 102, 241, 0.3);
            padding: 1rem 0;
        }
        
        .navbar-brand {
            font-weight: 700;
            font-size: 1.5rem;
            color: white !important;
        }
        
        .navbar-brand i {
            margin-right: 0.5rem;
        }
        
        .btn-back {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            border: 1px solid rgba(255, 255, 255, 0.3);
            padding: 0.5rem 1.25rem;
            border-radius: 8px;
            text-decoration: none;
            transition: all 0.3s;
            font-weight: 500;
        }
        
        .btn-back:hover {
            background: rgba(255, 255, 255, 0.3);
            color: white;
            transform: translateY(-2px);
        }
        
        .stats-container {
            padding: 2rem 0;
        }
        
        .stats-card {
            background: white;
            border-radius: 16px;
            padding: 1.5rem;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            display: flex;
            align-items: center;
            gap: 1rem;
            transition: transform 0.3s;
        }
        
        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 25px rgba(0, 0, 0, 0.1);
        }
        
        .stats-icon {
            width: 60px;
            height: 60px;
            background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-size: 1.5rem;
        }
        
        .stats-label {
            font-size: 0.875rem;
            color: var(--gray);
            font-weight: 500;
        }
        
        .stats-value {
            font-size: 1.75rem;
            font-weight: 700;
            color: var(--dark);
        }
        
        .content-container {
            padding: 0 0 3rem 0;
        }
        
        .table-card {
            background: white;
            border-radius: 16px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
            padding: 2rem;
        }
        
        .table-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 1.5rem;
            flex-wrap: wrap;
            gap: 1rem;
        }
        
        .table-title {
            font-size: 1.25rem;
            font-weight: 700;
            color: var(--dark);
            margin: 0;
        }
        
        .table-title i {
            color: var(--primary);
            margin-right: 0.5rem;
        }
        
        .btn-refresh {
            background: linear-gradient(135deg, #10b981 0%, #059669 100%);
            color: white;
            border: none;
            padding: 0.5rem 1.25rem;
            border-radius: 8px;
            font-weight: 600;
            transition: all 0.3s;
        }
        
        .btn-refresh:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(16, 185, 129, 0.3);
            color: white;
        }
        
        .table-responsive {
            border-radius: 12px;
            overflow: hidden;
        }
        
        .table {
            margin-bottom: 0;
        }
        
        .table thead {
            background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%);
            color: white;
        }
        
        .table thead th {
            border: none;
            padding: 1rem;
            font-weight: 600;
            text-transform: uppercase;
            font-size: 0.8rem;
            letter-spacing: 0.5px;
        }
        
        .table tbody td {
            padding: 1rem;
            vertical-align: middle;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .table tbody tr:hover {
            background: #f9fafb;
        }
        
        .badge-custom {
            padding: 0.5rem 1rem;
            border-radius: 20px;
            font-weight: 600;
            font-size: 0.75rem;
        }
        
        .badge-success {
            background: #d1fae5;
            color: #065f46;
        }
        
        .empty-state {
            text-align: center;
            padding: 3rem;
        }
        
        .empty-state i {
            font-size: 4rem;
            color: #d1d5db;
            margin-bottom: 1rem;
        }
        
        .empty-state h5 {
            color: var(--gray);
            margin-bottom: 0.5rem;
        }
        
        .empty-state p {
            color: #9ca3af;
        }
        
        @media (max-width: 768px) {
            .stats-card {
                margin-bottom: 1rem;
            }
            
            .table-header {
                flex-direction: column;
                align-items: flex-start;
            }
            
            .table-card {
                padding: 1rem;
            }
        }
        
        /* DataTables Custom Styling */
        .dataTables_wrapper .dataTables_length,
        .dataTables_wrapper .dataTables_filter {
            margin-bottom: 1rem;
        }
        
        .dataTables_wrapper .dataTables_paginate .paginate_button {
            border-radius: 6px !important;
            margin: 0 2px;
        }
        
        .dataTables_wrapper .dataTables_paginate .paginate_button.current,
        .dataTables_wrapper .dataTables_paginate .paginate_button.current:hover {
            background: linear-gradient(135deg, #6366f1 0%, #4f46e5 100%) !important;
            color: white !important;
            border: none;
        }
    </style>
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-custom">
        <div class="container">
            <a class="navbar-brand" href="#">
                <i class="fas fa-users-cog"></i>
                Admin Panel - Buku Tamu
            </a>
            <a href="index.php" class="btn-back">
                <i class="fas fa-arrow-left me-2"></i>Kembali ke Form
            </a>
        </div>
    </nav>

    <!-- Stats Section -->
    <div class="stats-container">
        <div class="container">
            <div class="row">
                <div class="col-md-4 mb-3">
                    <div class="stats-card">
                        <div class="stats-icon">
                            <i class="fas fa-users"></i>
                        </div>
                        <div>
                            <div class="stats-label">Total Tamu</div>
                            <div class="stats-value"><?php echo $total_tamu; ?></div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="stats-card">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #10b981 0%, #059669 100%);">
                            <i class="fas fa-user-check"></i>
                        </div>
                        <div>
                            <div class="stats-label">Tamu Hari Ini</div>
                            <div class="stats-value">
                                <?php
                                $today = date('Y-m-d');
                                $query_today = "SELECT COUNT(*) as count FROM tamu WHERE DATE(tanggal_kunjungan) = '$today'";
                                $result_today = mysqli_query($koneksi, $query_today);
                                $today_count = mysqli_fetch_assoc($result_today)['count'];
                                echo $today_count;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-4 mb-3">
                    <div class="stats-card">
                        <div class="stats-icon" style="background: linear-gradient(135deg, #f59e0b 0%, #d97706 100%);">
                            <i class="fas fa-clock"></i>
                        </div>
                        <div>
                            <div class="stats-label">Terakhir Update</div>
                            <div class="stats-value" style="font-size: 1rem;"><?php echo date('H:i:s'); ?></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Table Section -->
    <div class="content-container">
        <div class="container">
            <div class="table-card">
                <div class="table-header">
                    <h3 class="table-title">
                        <i class="fas fa-clipboard-list"></i>
                        Data Tamu Masuk
                    </h3>
                    <button onclick="location.reload()" class="btn btn-refresh">
                        <i class="fas fa-sync-alt me-2"></i>Refresh Data
                    </button>
                </div>
                
                <div class="table-responsive">
                    <?php if($total_tamu > 0): ?>
                        <table id="tamuTable" class="table table-striped">
                            <thead>
                                <tr>
                                    <th>No</th>
                                    <th>Nama Lengkap</th>
                                    <th>Email</th>
                                    <th>No. HP</th>
                                    <th>Instansi</th>
                                    <th>Keperluan</th>
                                    <th>Waktu Kunjungan</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $no = 1;
                                while($row = mysqli_fetch_assoc($result)) {
                                    echo "<tr>";
                                    echo "<td>" . $no++ . "</td>";
                                    echo "<td><strong>" . htmlspecialchars($row['nama_lengkap']) . "</strong></td>";
                                    echo "<td>" . htmlspecialchars($row['email']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['no_hp']) . "</td>";
                                    echo "<td>" . htmlspecialchars($row['instansi'] ?: '-') . "</td>";
                                    echo "<td>" . htmlspecialchars($row['keperluan']) . "</td>";
                                    echo "<td>" . date('d M Y, H:i', strtotime($row['tanggal_kunjungan'])) . "</td>";
                                    echo "</tr>";
                                }
                                ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <div class="empty-state">
                            <i class="fas fa-inbox"></i>
                            <h5>Belum Ada Data Tamu</h5>
                            <p>Data tamu yang mengisi form akan muncul di sini.</p>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
    
    <script>
        $(document).ready(function() {
            $('#tamuTable').DataTable({
                language: {
                    search: "Cari:",
                    lengthMenu: "Tampilkan _MENU_ data per halaman",
                    info: "Menampilkan _START_ sampai _END_ dari _TOTAL_ data",
                    infoEmpty: "Tidak ada data yang tersedia",
                    infoFiltered: "(difilter dari _MAX_ total data)",
                    paginate: {
                        first: "Pertama",
                        last: "Terakhir",
                        next: "Next",
                        previous: "Previous"
                    }
                },
                pageLength: 10,
                order: [[0, 'asc']]
            });
        });
    </script>

</body>
</html>

<?php
// Tutup koneksi
mysqli_close($koneksi);
?>