<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buku Tamu Digital</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600&display=swap" rel="stylesheet">
    <!-- FontAwesome Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
    
    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #f5f7fa 0%, #c3cfe2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .card-custom {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            overflow: hidden;
        }
        .card-header-custom {
            background: #4e54c8;
            background: -webkit-linear-gradient(to right, #8f94fb, #4e54c8);
            background: linear-gradient(to right, #8f94fb, #4e54c8);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        .form-control:focus {
            box-shadow: none;
            border-color: #4e54c8;
        }
        .btn-primary-custom {
            background: #4e54c8;
            border: none;
            padding: 10px 30px;
            font-weight: 600;
            transition: all 0.3s;
        }
        .btn-primary-custom:hover {
            background: #3b40a5;
            transform: translateY(-2px);
        }
    </style>
</head>
<body>

<div class="container py-5">
    <div class="row justify-content-center">
        <div class="col-lg-6 col-md-8">
            <div class="card card-custom">
                <div class="card-header-custom">
                    <h2 class="mb-0"><i class="fas fa-book-open me-2"></i>Buku Tamu Digital</h2>
                    <p class="mb-0 opacity-75">Silakan isi data kunjungan Anda</p>
                </div>
                <div class="card-body p-4">
                    <form action="simpan.php" method="POST">
                        <div class="mb-3">
                            <label class="form-label text-muted"><i class="fas fa-user me-2"></i>Nama Lengkap</label>
                            <input type="text" name="nama" class="form-control" placeholder="Masukkan nama anda" required>
                        </div>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label text-muted"><i class="fas fa-envelope me-2"></i>Email</label>
                                <input type="email" name="email" class="form-control" placeholder="email@contoh.com" required>
                            </div>
                            <div class="col-md-6 mb-3">
                                <label class="form-label text-muted"><i class="fas fa-phone me-2"></i>No. HP / WA</label>
                                <input type="text" name="no_hp" class="form-control" placeholder="0812..." required>
                            </div>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-muted"><i class="fas fa-building me-2"></i>Instansi / Perusahaan</label>
                            <input type="text" name="instansi" class="form-control" placeholder="PT. Maju Jaya (Opsional)">
                        </div>
                        <div class="mb-4">
                            <label class="form-label text-muted"><i class="fas fa-comment-dots me-2"></i>Keperluan</label>
                            <textarea name="keperluan" class="form-control" rows="3" placeholder="Jelaskan tujuan kunjungan..." required></textarea>
                        </div>
                        <div class="d-grid">
                            <button type="submit" name="kirim" class="btn btn-primary btn-primary-custom btn-lg rounded-pill">
                                Kirim Data <i class="fas fa-paper-plane ms-2"></i>
                            </button>
                        </div>
                    </form>
                </div>
                <div class="card-footer text-center bg-light py-3">
                    <small class="text-muted">Admin? <a href="admin.php" class="text-decoration-none">Login Disini</a></small>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>